<?php
/**
 *
 * Application:	LJM TweetStream
 * Copyright:	Lee Murphy 2010
 * Website:		http://www.leemurphy.co.uk
 * Date:		December 2010
 * License: 	GNU/GPL http://www.gnu.org/copyleft/gpl.html
 *
 */

defined('_JEXEC') or die('Direct Access to this location is not allowed.');
 
class LJMTweetStreamHelper
{

    // Call the Twitter API and get tweets
    public function getTweets($twitterid,$postcount,$showprofiledp,$linkprofiledp,$positionprofiledp,$showtwitterid,$linktwitterid,$hyperlinks,$linkmentions,$linkhashtags,$tweettime,$tweetlink,$followme,$followmetext)
    {
		// Function to format time strings
		function formatTime($timestamp)
		{
			// Use string-to-time to gen a unix timestamp
			$tweettime['unix'] = strtotime($timestamp);
			$tweettime['full'] = date("jS M",$tweettime['unix']);
			$tweettime['day'] = date("djY",$tweettime['unix']);
			$tweettime['year'] = date("y",$tweettime['unix']);
			$tweettime['hour'] = date("H",$tweettime['unix']);
			$tweettime['min'] = date("i",$tweettime['unix']);
			
			$currenttime['unix'] = time();
			$currenttime['day'] = date("djY",$currenttime['unix']);
			$currenttime['year'] = date("y",$currenttime['unix']);
			$currenttime['hour'] = date("H",$currenttime['unix']);
			$currenttime['min'] = date("i", $currenttime['unix']);
			
			// Check to see if the tweet was today
			if($currenttime['day'] == $tweettime['day'])
			{
				// Calculate hours past	
				$hours = ((int)$currenttime['hour'] - (int)$tweettime['hour']);
				
				// If less than an hour ago show how many minutes
				if($hours == 0)
				{
					// Calcylate minutes past
					$minutes = ((int)$currenttime['min'] - (int)$tweettime['min']);
					$time = $minutes." minutes ago";
				} 
				else
				{
					// if time was 1 hour ago
					if($hours == 1)
						$time = $hours." hour ago";
					else
						$time = $hours." hours ago";
				}
			}
			// Otherwise post the date
			else
			{
				// Check to see if the year is the same
				if($currenttime['year'] == $tweettime['year'])
				{
					$time = $tweettime['full'];
				}
				else
				{
					$time = $tweettime['full']." ".$tweettime['year'];
				}
			}
			
			return $time;
				
		}
		
		// Function to generate hyperlinks
		function createLinks($text,$type)
		{
		  
		  // Reg ex
		  $reg_exUrl = "/(http|https|ftp|ftps)\:\/\/[a-zA-Z0-9\-\.]+\.[a-zA-Z]{2,3}(\/\S*)?/"; 
		  $reg_exUsername = "/@([a-z_0-9]+)/i";
		  $reg_exHashtag = "/#([a-z_0-9]+)/i";
			  
		  switch($type)
		  {
			  case "url":
				  $find = $reg_exUrl;
				  $replace = "<a href=\"$0\" target=\"_blank\">$0</a>";
				  break;
			  case "mention":
				  $find = $reg_exUsername;
				  $replace = "<a href=\"http://twitter.com/$1\" target=\"_blank\">$0</a>";
				  break;
			  case "hash":
				  $find = $reg_exHashtag;
				  $replace = "<a href=\"http://twitter.com/search?q=%23$1\" target=\"_blank\">$0</a>";
				  break;
		  }
		  
		  // Check if there is a url in the text 
		  if(preg_match($find, $text)) 
		  {           
			  // Check for urls in text
			  $text = preg_replace($find, $replace, $text);    
		  }
			  
		  return $text;
		
		}
		
	
		// Declare some variables
		$tweetdata = array(array());
		$tweets = array();
		$i = 0;
		$j = 0;
		
		// Construct twitter api url
		// User timeline
		$url = "http://api.twitter.com/1/statuses/user_timeline.xml?screen_name=".$twitterid."&count=".$postcount."&include_rts=true";
				
		// Check to see if allow_url_fopen is enabled on the server
		if (ini_get('allow_url_fopen')) {
    		
			$xml = @simplexml_load_file($url);
 		
		// If not use cURL instead to retrieve XML
		} else {
		
			$ch = curl_init($url);
			curl_setopt($ch, CURLOPT_HEADER, false);
			curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
			$xml_raw = curl_exec($ch);
			curl_close($ch);
			$xml = simplexml_load_string($xml_raw);
		
		}
		
		// If we sucessfully returned an xml
		if($xml)
		{
			// Get each tweet as array data
			foreach($xml->status as $status)
			{
				$tweetdata[$i][tuser] = $status->user->screen_name;
				$tweetdata[$i][tuserdp] = $status->user->profile_image_url;
				$tweetdata[$i][ttext] = $status->text;
				$tweetdata[$i][ttime] = $status->created_at;
				$tweetdata[$i][tid] = $status->id;
				$i++;
			}
		
			// Build each tweet from array data into single text array
			foreach($tweetdata as $tweetdatatemp){
				
				// Start tweet 'span'
				$tweets[$j] = "<span class=\"tweet\">";
				//$tweets[$j] = "";
				
				if($showprofiledp == 1)
				{
					if($linkprofiledp == 1)
						$tweets[$j] = $tweets[$j]."<a href=\"http://twitter.com/".$tweetdatatemp[tuser]."\" target=\"_blank\"><img src=\"".$tweetdatatemp[tuserdp]."\" width=\"48px\" height=\"48px\" align=\"".$positionprofiledp."\" alt=\"".$tweetdatatemp[tuser]."\" style=\"padding: 2px; border: none;\" /></a>";
					else
						$tweets[$j] = $tweets[$j]."<img src=\"".$tweetdatatemp[tuserdp]."\" width=\"48px\" height=\"48px\" align=\"".$positionprofiledp."\" alt=\"".$tweetdatatemp[tuser]."\" style=\"padding: 2px;\" />";
				}
				
				// Check whether to post the name of the twitter user
				if($showtwitterid == 1)
				{
					// Check whether to link the name to the twitter page
					if($linktwitterid == 1)				
						$tweets[$j] = $tweets[$j]."<a href=\"http://twitter.com/".$tweetdatatemp[tuser]."\" target=\"_blank\">".$tweetdatatemp[tuser]."</a>: ";
					else
						$tweets[$j] = $tweets[$j].$tweetdatatemp[tuser].": ";	
				}
				
				// Replace URLs with hyperlinks
				if($hyperlinks == 1)
					$tweetdatatemp[ttext] = createLinks($tweetdatatemp[ttext],"url");
					
				// Replace mentions with hyperlinks
				if($linkmentions == 1)
					$tweetdatatemp[ttext] = createLinks($tweetdatatemp[ttext],"mention");
					
				// Replace hashtags with hyperlinks
				if($linkhashtags == 1)
					$tweetdatatemp[ttext] = createLinks($tweetdatatemp[ttext],"hash");
					
				// Add tweet text into tweet string
				$tweets[$j] = $tweets[$j].$tweetdatatemp[ttext];
				
				// Add tweet time
				if($tweettime == 1)
				{
					if(tweetlink ==1)
						$tweets[$j] = $tweets[$j]." - ".formatTime($tweetdatatemp[ttime]);
					else
						$tweets[$j] = $tweets[$j]." - <a href=\"http://twitter.com/".$tweetdatatemp[tuser]."/status/".$tweetdatatemp[tid]."\" target=\"_blank\">".formatTime($tweetdatatemp[ttime])."</a>";	
				}
				
				// End tweet 'span'
				$tweets[$j] = $tweets[$j]."</span>";
				
				$j++;
				
			}
		
		// Display an error if we cannot get access to twitter
		} else {
			
			echo "<span class=\"tweet\">Sorry, I'm unable to connect to Twitter right now.</span>";
		}
		
		// Add follow me link
		if($followme == 1)
		{
			$tweets[($j + 1)] = "<span class=\"followlink\"><a href=\"http://twitter.com/".$tweetdatatemp[tuser]."\" target=\"_blank\">".$followmetext."</a><span>";
		}
		
  		return $tweets;
		
    } // End getTweets
 
} //end LJMTweetStreamHelper

?>